
<?php

// Function to get the visitor's IP address
function getIPAddress() {
    // Check for shared Internet/ISP IP
    if (!empty($_SERVER['HTTP_CLIENT_IP']) && validateIP($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    }

    // Check for IP address from a proxy server
    if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        // Check if multiple IP addresses exist in the HTTP_X_FORWARDED_FOR header
        $ipAddresses = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
        foreach ($ipAddresses as $ip) {
            if (validateIP($ip)) {
                return $ip;
            }
        }
    }

    // Check for IP address in the REMOTE_ADDR header
    if (isset($_SERVER['REMOTE_ADDR']) && validateIP($_SERVER['REMOTE_ADDR'])) {
        return $_SERVER['REMOTE_ADDR'];
    }

    // Return unreliable IP address if all else fails
    return 'Unknown';
}

// Function to validate an IP address
function validateIP($ip) {
    if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 | FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) === false) {
        return false;
    }
    return true;
}

// Get the visitor's IP address
$ipAddress = getIPAddress();

// Use IP geolocation API (replace 'YOUR_API_KEY' with your actual API key)
$apiKey = 'YOUR_API_KEY';
$apiUrl = "https://api.ipgeolocationapi.com/geolocate/$ipAddress";
$response = file_get_contents($apiUrl);
$data = json_decode($response, true);

// Extract country information from the API response
$country = $data['country_name'];

// Output the IP address and country
echo "IP Address: $ipAddress<br>";
echo "Country: $country";

?>







<style>
    @import 'https://fonts.googleapis.com/css?family=Inconsolata';

html {
  min-height: 100%;
}

body {
  box-sizing: border-box;
  height: 100%;
  background-color: #000000;
  background-image: radial-gradient(#11581E, #041607);
  font-family: 'Inconsolata', Helvetica, sans-serif;
  font-size: 1.5rem;
  color: rgba(128, 255, 128, 0.8);
  text-shadow: 0 0 1ex rgba(51, 255, 51, 1), 0 0 2px rgba(255, 255, 255, 0.8);
}

.overlay {
  pointer-events: none;
  position: absolute;
  width: 100%;
  height: 100%;
  background: repeating-linear-gradient(180deg, rgba(0, 0, 0, 0) 0, rgba(0, 0, 0, 0.3) 50%, rgba(0, 0, 0, 0) 100%);
  background-size: auto 4px;
  z-index: 99;
}

.overlay::before {
  content: "";
  pointer-events: none;
  position: absolute;
  display: block;
  top: 0;
  left: 0;
  right: 0;
  bottom: 0;
  width: 100%;
  height: 100%;
  background-image: linear-gradient(0deg, transparent 0%, rgba(32, 128, 32, 0.2) 2%, rgba(32, 128, 32, 0.8) 3%, rgba(32, 128, 32, 0.2) 3%, transparent 100%);
  background-repeat: no-repeat;
  animation: scan 7.5s linear 0s infinite;
}

@keyframes scan {
  0% { background-position: 0 -100vh; }
  35%, 100% { background-position: 0 100vh; }
}

.terminal {
  box-sizing: inherit;
  position: absolute;
  height: 100%;
  width: 1000px;
  max-width: 100%;
  padding: 4rem;
  text-transform: uppercase;
}

.output {
  color: rgba(128, 255, 128, 0.8);
  text-shadow: 0 0 1ex #3f3, 0 0 2px rgba(255, 255, 255, 0.8);
}

.output::before {
  content: "> ";
}

.input {
  color: rgba(192, 255, 192, 0.8);
  text-shadow: 0 0 1ex #3f3, 0 0 2px rgba(255, 255, 255, 0.8);
}

.input::before {
  content: "$ ";
}

a {
  color: #fff;
  text-decoration: none;
}

a::before {
  content: "[";
}

a::after {
  content: "]";
}

.errorcode {
  color: white;
}

.copyright {
  font-size: .7rem;
}
</style>











<div class="overlay"></div>
<div class="terminal">
  <h1>Error <span class="errorcode">404</span></h1>
  <p class="output">The page you are looking for might have been removed, had its name changed or is temporarily unavailable</ü>
  <p class="output">Please try <a href="#1">this link</a> or <a href="#2">this link</a></p>
  <p class="output">Good luck</p>
</div>